DROP TABLE IF EXISTS invalid_lhs;
CREATE TABLE invalid_lhs (
                           id serial8 not null primary key,
                           t text
);

INSERT INTO invalid_lhs (t) VALUES ('This is a TEST');

CREATE INDEX idxinvalid_lhs ON invalid_lhs USING bm25 (
   id,
   t,
   (t::pdb.literal('alias=literal')),
   (t::pdb.simple('alias=simple')),
   (t::pdb.ngram(2, 3, 'alias=ngram_2_3')),
   (t::pdb.ngram(3, 5, 'alias=ngram_3_5'))
) WITH (key_field = 'id');

-- this one is valid
SELECT * FROM invalid_lhs WHERE t::text @@@ 'this is a test';

--
-- all of these are invalid
--
SELECT * FROM invalid_lhs where (t::pdb.literal) @@@ 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=oopsie')) @@@ 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=simple', 'stemmer=english')) @@@ 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.ngram(3, 6)) @@@ 'This is a TEST';

SELECT * FROM invalid_lhs where (t::pdb.literal) &&& 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=oopsie')) &&& 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=simple', 'stemmer=english')) &&& 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.ngram(3, 6)) &&& 'This is a TEST';

SELECT * FROM invalid_lhs where (t::pdb.literal) ||| 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=oopsie')) ||| 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=simple', 'stemmer=english')) ||| 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.ngram(3, 6)) ||| 'This is a TEST';

SELECT * FROM invalid_lhs where (t::pdb.literal) ### 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=oopsie')) ### 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=simple', 'stemmer=english')) ### 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.ngram(3, 6)) ### 'This is a TEST';

SELECT * FROM invalid_lhs where (t::pdb.literal) === 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=oopsie')) === 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.simple('alias=simple', 'stemmer=english')) === 'This is a TEST';
SELECT * FROM invalid_lhs where (t::pdb.ngram(3, 6)) === 'This is a TEST';
