-- Test that the system reports a sensible error when the supplied
-- query returns a bad QR_Message (column 2)

-- This is something of a vanity test, because we already test
-- the exceptions.

BEGIN;

-- Update the query to something broken
UPDATE isok_queries
  SET query = $$VALUES ('R1', 'Result number 1', NULL)
                     , ('R2', NULL, NULL)
                     , ('R3', 'Result number 3', NULL);$$
  WHERE iqname = 'query1';

-- See that the error is trapped
SELECT *
  FROM run_isok_queries($$VALUES ('query1');$$)
  ORDER BY irid;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
