-- Test that the system reports a sensible error when
-- the executed sql raises a integrity_constraint_violation

BEGIN;

-- run_isok_queries() expects an expression that returns results
-- from a table.  So create a function that does that, but instead
-- raises the error we want to test.

CREATE FUNCTION test_func()
  RETURNS TABLE (c1 TEXT, c2 TEXT, c3 TEXT)
  LANGUAGE plpgsql
  AS $$
     BEGIN
       RAISE EXCEPTION integrity_constraint_violation USING
         MESSAGE = 'Test of integrity_constraint_violation';
     END;
     $$;

-- Update the query to raise the error
UPDATE isok_queries
  SET query = $$SELECT * FROM test_func();$$
  WHERE iqname = 'query1';

-- Run to see trapped error
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1');$$)
  ORDER BY irid;

ROLLBACK;
