-- pg_isok  A query centered monitoring tool for PostgreSQL
-- Copyright (C) 2025 The Meme Factory, Inc.  http://www.karlpinc.com/
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Affero General Public License for more details.
--
--  You should have received a copy of the GNU Affero General Public License
--  along with this program.  If not, see <https://www.gnu.org/licenses/>.
--
-- Karl O. Pinc <kop@karlpinc.com>
--
-- Remarks:
--   Hand-written comments.
--   Note that comments extracted from the documentation are appended
--   to this file.
--
--   Line breaks at 50 columns, since that's what format_comments.gawk does.

--
-- Support table columns.
--

-- IQ_TYPES
COMMENT ON COLUMN iq_types.iqtype IS
  'A classification code attached to a query in the
ISOK_QUERIES table.';
  
COMMENT ON COLUMN iq_types.description IS
  'A description of the IQType code.';

-- IRTypes
COMMENT ON COLUMN ir_types.irtype IS
  'A classification code attached to a query result
row in the ISOK_RESULTS table.';

COMMENT ON COLUMN ir_types.description IS
  'A description of the IRType code.';

--
-- Comment the functions used by people
--

-- run_isok_queries()

COMMENT ON FUNCTION run_isok_queries() IS
  'Execute all the queries in the ISOK_QUERIES table and
return a table of the results.';

COMMENT ON FUNCTION run_isok_queries(query TEXT) IS
  'Execute the supplied query, which produces a single
column of ISOK_QUERIES.IQName values, and then
execute all the queries in the ISOK_QUERIES table
with those IQName values, returning a table of the
result of the executed queries.';

--
-- Comment the functions used by triggers
--

COMMENT ON FUNCTION isok_queries_update_func() IS
  'Internal function: Implements an AFTER UPDATE FOR EACH
ROW trigger on ISOK_QUERIES';

COMMENT ON FUNCTION isok_results_func() IS
  'Internal function: Implements an AFTER INSERT OR UPDATE
FOR EACH ROW trigger on ISOK_RESULTS';

--
-- Everything that follows is extracted from the documentation.
--
