dnl Copyright (C) 2016 The Meme Factory, Inc.  http://www.karlpinc.com/
dnl Copyright (C) 2004-2006, 2008-2010, Karl O. Pinc <kop@karlpinc.com>
dnl Copyright (C) 2016, 2022 Jake Gordon, <jacob.gordon@duke.edu>
dnl
dnl  This program is free software: you can redistribute it and/or modify
dnl  it under the terms of the GNU Affero General Public License as published
dnl  by the Free Software Foundation, either version 3 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU Affero General Public License for more details.
dnl
dnl  You should have received a copy of the GNU Affero General Public License
dnl  along with this program.  If not, see <https://www.gnu.org/licenses/>.
dnl
dnl Karl O. Pinc <kop@karlpinc.com>
dnl
dnl
changequote([{[,]}])dnl m4 foolery so includes include only once.
dnl                     Once the macro is in the text, change the quotes back
ifdef([{[_triggermacros.m4]}], [{[changequote(`,')]}], [{[dnl
changequote(`,')dnl
dnl
dnl Standard test for having already included the file.
define(`_triggermacros.m4')dnl
dnl
dnl
dnl Discard any output.  Copyright and edit warning is all that's output.
divert(-1)

dnl
dnl Inline expressions
dnl

dnl sql fragment to cast values which might be NULL to text.
dnl
dnl Syntax: textualize(expr)
dnl
dnl expr  An expression which might be NULL.
dnl
dnl Remarks:
dnl  Useful when raising errors to get a uniform external NULL
dnl representation.
dnl
changequote({,})
define({textualize},{CASE WHEN $1 IS NULL THEN 'NULL' ELSE $1::TEXT END
})dnl
changequote(`,')


dnl Plpgsql fragment for preventing a column from changing.
dnl
dnl Syntax: cannot_change(table, column)
dnl Variables required:
dnl Restrictions: Must be used in a FOR EACH ROW update trigger function.
changequote({,})
define({cannot_change}, {
  IF NEW.$2 <> OLD.$2 THEN
    -- $2 has changed
    RAISE EXCEPTION integrity_constraint_violation USING
          MESSAGE = 'Error on UPDATE of $1'
        , DETAIL =  'Value ($2) = (' || OLD.$2
                    || '): $1.$2 cannot be changed';
    RETURN NULL;
  END IF;
})
changequote(`,')

dnl Turn output back on
divert`'dnl
]}])dnl End of ifdef over the whole file.
