-- Giving a query to run_iok_queries runs only those queries.


BEGIN;

-- Omit the role, search_path, and (non-NULL) timestamps from the
-- column list, they change and cause the test to fail.
SELECT irid, iqname, deferred_to, type
     , keep_until, qr_id, qr_message, qr_extra, notes
  FROM run_isok_queries($$VALUES ('query1');$$) AS riq
  ORDER BY riq.irid;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
