-- The resolved results are updated, even when not output.
-- Check QR_Message, and QR_Extra.
-- But this can't test for the update of Last_Seen.

BEGIN;

-- Run query1 for the first time to get results
-- But don't show timestamps
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1')$$)
  ORDER BY irid;

-- Save the results so we can compare them later
-- because we can't "display" the timestamps because
-- that will show up as a test failure.
CREATE TEMP TABLE _saved_results AS
  SELECT * FROM isok_results;

-- Update the warnings so they are resolved.
UPDATE isok_results
  SET resolved = first_seen
  WHERE iqname = 'query1';

-- Update the query so that it returns new results
UPDATE isok_queries
  SET query =  $$VALUES ('R1', 'Updated result number 1', '[]')
                      , ('R2', 'Updated result number 2', '[]')
                      , ('R3', 'Updated result number 3', '[]');$$
  WHERE iqname = 'query1';

-- Examine what happens when we run again.
-- We should see no output
SELECT irid, iqname, qr_id, qr_message, qr_extra
  FROM run_isok_queries($$VALUES ('query1')$$)
  ORDER BY irid;

-- But there should be updated values in ISOK_RESULTS
-- Display something if the values have not changed
-- This should produce no rows.
SELECT *
  FROM isok_results
    JOIN _saved_results ON (_saved_results.irid = isok_results.irid)
  WHERE _saved_results.qr_message = isok_results.qr_message
        OR _saved_results.qr_extra = isok_results.qr_extra;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
