dnl Copyright (C) 2016 Jake Gordon, <jacob.gordon@duke.edu>
dnl Copyright (C) 2015, 2024, 2025 The Meme Factory, Inc.
dnl               http://www.karlpinc.com/
dnl Copyright (C) 2007, 2008, 2010, 2011, Karl O. Pinc
dnl
dnl  This program is free software: you can redistribute it and/or modify
dnl  it under the terms of the GNU Affero General Public License as published
dnl  by the Free Software Foundation, either version 3 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU Affero General Public License for more details.
dnl
dnl  You should have received a copy of the GNU Affero General Public License
dnl  along with this program.  If not, see <https://www.gnu.org/licenses/>.
dnl
dnl Karl O. Pinc <kop@karlpinc.com>
dnl
dnl Macros used to create tables.
dnl
dnl
dnl Define m4 macros so we don't have to type so much.
dnl (Or at least type stuff that's more fun.)
dnl
dnl Watch out for using the single quote char as it has special
dnl meaning to m4.
dnl
dnl Bugs:
dnl
changequote([{[,]}])dnl m4 foolery so includes include only once.
dnl                     Once the macro is in the text, change the quotes back
ifdef([{[_tablemacros.m4]}], [{[changequote(`,')]}], [{[dnl
changequote(`,')dnl
dnl
dnl Standard test for having already included the file.
define(`_tablemacros.m4')dnl
dnl
dnl Don't output anything while defining macros.
divert(-1)

dnl Create a support table.
dnl Syntax: support_table(tablename, id_name, id_datatype, id_constraint)
define(`support_table',`
CREATE TABLE $1 (
  $2 $3 PRIMARY KEY NOT NULL $4,
  Description TEXT NOT NULL
        empty_string_check(Description)
);
')


--
-- Column constraints
--

-- A constant that consists of whitespace
changequote([,])
define([isok_whitespace_chars], [E' \r\n\t\f\x0B'])dnl
changequote(`,')dnl  See above.

-- A column cannot contain the empty string or only whitespace
--
-- Syntax: empty_string_check(col)
--
-- Input:
--   col  Name of the column to check.
--
changequote([,])
define([empty_string_check], [           CONSTRAINT "$1: Cannot be empty or only whitespace characters"
                CHECK(btrim($1, isok_whitespace_chars) <> '')])dnl
changequote(`,')dnl  See above.

-- A column cannot contain only whitespace.
--
-- Syntax: not_only_spaces_check(col)
--
-- Input:
--   col  Name of the column to check.
--
changequote([,])
define([not_only_spaces_check], [           CONSTRAINT "$1: Cannot be only whitespace characters"
                CHECK($1 IS NULL OR $1 = '' OR btrim($1, isok_whitespace_chars) <> '')])dnl
changequote(`,')dnl  See above.

-- A column cannot contain any whitespace.
--
-- Syntax: no_spaces_check(col)
--
-- Input:
--   col  Name of the column to check.
--
changequote([,])
define([no_spaces_check], [           CONSTRAINT "$1: Cannot contain any whitespace characters"
                CHECK($1 IS NULL OR
                      $1 !~ '( |\r|\n|\t|\f|\x0B)')])dnl
changequote(`,')dnl  See above.

-- Done defining macros.
divert`'dnl

]}])dnl End of ifdef over the whole file.
