-- Calling run_isok_queries() without an argument runs all the queries.

-- Use a transaction to keep from altering ISOK_RESULTS.
BEGIN;

-- Show the queries that should run
SELECT iqname, query
  FROM isok_queries
  ORDER BY iqname;

-- Omit the role, search_path, and (non-NULL) timestamps from the
-- column list, they change and cause the test to fail.

-- Output the expected 6 rows from the 2 executed queries.
SELECT irid, iqname, deferred_to, type
     , keep_until, qr_id, qr_message, qr_extra, notes
  FROM run_isok_queries() AS riq
  ORDER BY riq.irid;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);


