<?xml version='1.0'?>
<xsl:stylesheet version='1.0'
                xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:isok="http://karlpinc.com/isok">
  <isok:comment>
  Copyright (C) 2025 The Meme Factory, Inc.  https://karlpinc.com
  Copyright (C) 2005, 2008, 2010, Karl O. Pinc kop@karlpinc.com

     This program is free software: you can redistribute it and/or modify
     it under the terms of the GNU Affero General Public License as published
     by the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU Affero General Public License for more details.

     You should have received a copy of the GNU Affero General Public License
     along with this program.  If not, see https://www.gnu.org/licenses/.

    Karl O. Pinc kop@karlpinc.com

  There, that set it up so we can have comments.
  From: http://www.dpawson.co.uk/xsl/index.html
        http://www.dpawson.co.uk/xsl/sect2/comments.html#d2747e112

  If this were not "top level" we'd have to also have
  <xsl:fallback/>
  somewhere in here.

  The topmost 2 lines are basic and required Header Information.
  </isok:comment>
  <isok:comment>
    This stylesheet is used by the Makefile to customize all output,
    although some of what's in here only affects xhtml output.
  </isok:comment>

  <isok:comment>
    3 levels of section headings in the table of contents.
    2 levels in section contents.
  </isok:comment>
  <xsl:param name="toc.section.depth" select="2"/>
  <xsl:param name="toc.max.depth" select="3"/>

  <isok:comment>
    Put the legal notice in a separate page.
  </isok:comment>
  <xsl:param name="generate.legalnotice.link" select="1"/>
  <xsl:param name="use.id.as.filename" select="1"/>

  <isok:comment>
    In html, put the first section in a separate chunk
    (web page) from the table of contents.
  </isok:comment>
  <xsl:param name="chunk.first.sections" select="1"/>

  <isok:comment>
    Do chunk sections out of chapters.
  <xsl:param name="chunk.section.depth" select="1"/>
  </isok:comment>

  <isok:comment>
    Have external links show up in footnotes.
  </isok:comment>
  <xsl:param name="xref.with.number.and.title" select="0"/>

  <isok:comment>
    Have xref's to sections and refsections contain just the section name and
    not "the section titled: blah".  This is so that we don't
    have to put "xreflabel" attributes in all the sections,
    or alternately use our own text in link tags.
  </isok:comment>
  <xsl:param name="local.l10n.xml" select="document('')"/> 
  <l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0"> 
    <l:l10n language="en"> 
    <l:context name="xref">
      <l:template name="section" text="%t"/>
      <l:template name="refsection" text="%t"/>
      </l:context>    
    </l:l10n>
  </l:i18n>

  <isok:comment>
    Segmented lists are tables.
  </isok:comment>
  <xsl:param name="segmentedlist.as.table" select="1"/>

  <isok:comment>
    Put the time of document generation in the footer of
    chunked html.
  </isok:comment>
  <xsl:template name="user.footer.navigation">
    <hr width="20" align="left" />
    <p class="usernavfooter">
      Page generated: <xsl:value-of select="date:date-time()">
        <xsl:fallback>
          <xsl:message terminate="yes">
            ERROR: Your processor does not support date:date-time
          </xsl:message>
        </xsl:fallback>
      </xsl:value-of>.
    </p>
  </xsl:template>

  <isok:comment>
    Put a link to the table of contents at the top
    of every page.
  <xsl:template name="user.header.navigation">

  </xsl:template>
  </isok:comment>

  <isok:comment>
   This adds a dot after an honorific, in this case a PhD.
  </isok:comment>

 <isok:comment>
   Generate a name.
   From common/common.xsl

   To really do this right we'd need to:
    Have a person.name (or maybe author) attribute set:
      order  last-first, first-last, etc.
      honorific.is.prefix  True or false
    Have a punct.honorific attribute set:
      suffix (or null) suffixes the honorific
      separator   separates honorific from name (when suffix)
    Have a gentext template to generate the honorific
      separator when the honorific is a suffix.
    Have a gentext template that returns true (is prefix)
      or false and allows honorific role=prefix or suffix.
      It would take a param which says whether the attribute
      set wants a prefix or a suffix.  (May as well take the whole
      attribute set as a param.)
      It would test the parameter in the attribute set too.
    Then the person.name template does the logic.

   To avoid extending the docbook DTD keep it simple and don't
   require a role attribute.  Pretty much move the honorific
   down to the bottom and get rid of the extra tests beforehand.

   Here's some sample code that uses a role attribute in the
   honorific element.  But it does not work quite right.

 <xsl:template name="person.name.first-last">
  <xsl:param name="node" select="."/>

  <xsl:variable name="trailing-honorific">
    <xsl:choose>
      <xsl:when test="$node//honorific and $node//honorific[@role='suffix']">
        1
      </xsl:when>
      <xsl:otherwise>
        0
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:if test="$node//honorific and $trailing-honorific = 0">
    <xsl:apply-templates select="$node//honorific[1]"/>
    <xsl:value-of select="$punct.honorific"/>
  </xsl:if>

  <xsl:if test="$node//firstname">
    <xsl:if test="$node//honorific">
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="$node//firstname[1]"/>
  </xsl:if>

  <xsl:if test="$node//othername and $author.othername.in.middle != 0">
    <xsl:if test="$node//honorific or $node//firstname">
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="$node//othername[1]"/>
  </xsl:if>

  <xsl:if test="$node//surname">
    <xsl:if test="$node//honorific or $node//firstname
                  or ($node//othername and $author.othername.in.middle != 0)">
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="$node//surname[1]"/>
  </xsl:if>

  <xsl:if test="$node//lineage">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates select="$node//lineage[1]"/>
  </xsl:if>

  <xsl:if test="$trailing-honorific != 0">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates select="$node//honorific[1]"/>
    <xsl:value-of select="$punct.honorific"/>
  </xsl:if>
</xsl:template>
</isok:comment>

 <xsl:template name="person.name.first-last">
  <xsl:param name="node" select="."/>

  <xsl:if test="$node//firstname">
    <xsl:apply-templates select="$node//firstname[1]"/>
  </xsl:if>

  <xsl:if test="$node//othername and $author.othername.in.middle != 0">
    <xsl:if test="$node//honorific or $node//firstname">
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="$node//othername[1]"/>
  </xsl:if>

  <xsl:if test="$node//surname">
    <xsl:if test="$node//firstname
                  or ($node//othername and $author.othername.in.middle != 0)">
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="$node//surname[1]"/>
  </xsl:if>

  <xsl:if test="$node//lineage">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates select="$node//lineage[1]"/>
  </xsl:if>

  <xsl:if test="$node//honorific">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates select="$node//honorific[1]"/>
    <xsl:value-of select="$punct.honorific"/>
  </xsl:if>
</xsl:template>
</xsl:stylesheet>
