-- Test that the ISOK_RESULTS.Last_Role column is set

BEGIN;

-- Pretend that we're never going to have a collision with an existing
-- role on the cluster.
CREATE ROLE isok_regression_testing_role NOLOGIN;

-- Create a query to run as the role
INSERT INTO isok_queries (
    iqname, error, type, keep
    -- , first_run, last_run
  , role, search_path, query, comment)
  VALUES('role_test'
       , false
       , 'type1'
       , false

       , 'isok_regression_testing_role'
       , NULL
       , $$VALUES ('R1', current_user, NULL);$$
       , 'No comment'
       );

-- Run the query
-- We should see the isok_regression_testing_role as the message,
-- and the role.
SELECT riq.last_role, riq.qr_message
  FROM run_isok_queries($$VALUES ('role_test');$$) AS riq;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
