-- Running the query for the first time sets the ISOK_RESULTS.First_Seen
-- and Last_Seen timestamps to the CURRENT_TIMESTAMP.

BEGIN;

-- Omit the (non-NULL) timestamps.
SELECT 1  FROM run_isok_queries() AS riq;

-- Show unexpected *_Seen timestamp values.
-- (All should return 0 rows.)
SELECT *
  FROM isok_results
  WHERE isok_results.first_seen <> CURRENT_TIMESTAMP::TIMESTAMP(0);

SELECT *
  FROM isok_results
  WHERE isok_results.last_seen <> CURRENT_TIMESTAMP::TIMESTAMP(0);

SELECT *
  FROM isok_results
  WHERE isok_results.last_seen <> isok_results.first_seen;

ROLLBACK;


-- Cleanup

-- Reset the sequence so what this test did is ignored.
SELECT setval('isok_results_irid_seq', 1, FALSE);
