BEGIN; 

CREATE EXTENSION aggs_for_vecs;

DROP TABLE IF EXISTS measurements;
CREATE TABLE measurements (
  sensor_id INTEGER PRIMARY KEY,
  smallints SMALLINT[],
  ints INT[],
  bigints BIGINT[],
  reals REAL[],
  floats FLOAT[],
  nums NUMERIC[]
);
CREATE INDEX idx_measurements_sensor_id ON measurements (sensor_id);

INSERT INTO measurements
VALUES
(1, NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL),
(2, ARRAY[NULL, NULL, NULL]::smallint[],
    ARRAY[NULL, NULL, NULL]::int[],
    ARRAY[NULL, NULL, NULL]::bigint[],
    ARRAY[NULL, NULL, NULL]::real[],
    ARRAY[NULL, NULL, NULL]::float[],
    ARRAY[NULL, NULL, NULL]::numeric[]),
(3, ARRAY[1, 2, 3],
    ARRAY[1, 2, 3],
    ARRAY[1, 2, 3],
    ARRAY[1, 2, 3],
    ARRAY[1, 2, 3],
    ARRAY[1.23, 2.34, 3.45]),
(4, ARRAY[1, NULL, 2],
    ARRAY[1, NULL, 2],
    ARRAY[1, NULL, 2],
    ARRAY[1, NULL, 2],
    ARRAY[1, NULL, 2],
    ARRAY[1.23, NULL, 2.34]),
(5, ARRAY[1, 2, 4],
    ARRAY[1, 2, 4],
    ARRAY[1, 2, 4],
    ARRAY[1, 2, 4],
    ARRAY[1, 2, 4],
    ARRAY[1.23, 2.34, 4.45]),
(6, ARRAY[1, 1, 4],
    ARRAY[1, 1, 4],
    ARRAY[1, 1, 4],
    ARRAY[1, 1, 4],
    ARRAY[1, 1, 4],
    ARRAY[1.23, 1.23, 4.56])
;

DROP TABLE IF EXISTS measurements2;
CREATE TABLE measurements2 (
  stream_id TEXT NOT NULL,
  ts TIMESTAMP WITH TIME ZONE NOT NULL,
  data_i NUMERIC[],
  data_a NUMERIC[],
  data_s TEXT[],
  PRIMARY KEY (stream_id, ts)  
);

COPY measurements2 FROM STDIN DELIMITER ',' CSV HEADER;
"stream_id","ts","data_i","data_a","data_s"
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:04:17.011+13","{31,-1.348291,228.79181,49.664787,3021,0.99999994,-23.358469,3021,1}","{6255484}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:05:17.004+13","{5933,25.575808,231.44753,49.88478,5905,0.99999981,232.00935,5905,3}","{6255582,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:06:17.001+13","{11891,-146.338032,228.67136,50.306194,94169,0.99999998,-81.25856,94169,16}","{6257151,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:07:17.001+13","{0,0.076971,234.48444,49.68349,2754,1,1.5362356,2754,0}","{6257196,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:08:17.003+13","{12656,-53.70807,231.69998,49.836285,12234,0.99999916,-235.66092,12234,15}","{6257399,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:09:17.001+13","{6286,24.489382,226.81848,50.47607,4908,0.99999993,256.68625,4908,1}","{6257480,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:10:17.005+13","{1844,-9.616372,233.76501,50.355034,2739,0.99999995,-191.82733,2739,0}","{6257525,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:11:17.006+13","{4204,18.940187,227.44914,49.77936,4413,0.99999988,222.00691,4413,2}","{6257598,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:12:17.001+13","{58,1.831774,225.00537,50.47512,2893,1,32.049065,2893,0}","{6257646,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:14:00.004+13","{13464,-60.825908,234.49796,50.07864,15109,0.99999951,-221.36913,15109,14}","{6255494,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:20:16.006+13","{991,8.267037,234.90681,50.23564,3803,0.99999992,119.942154,3803,1}","{6255500}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 15:21:19.009+13","{88577,-274.650821,229.21931,49.512825,44744,1,-322.5085,44744,0}","{6255501}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:38:54.006+13","{21125,-68.534879,227.56502,49.56336,11514,0.99999999,-308.243,11514,1}","{6255698}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:39:54.001+13","{3000,-28.823805,230.08878,50.462532,14658,0.99999851,-104.0976,14658,25}","{6255942,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:40:54.002+13","{23200619,-75585.95336,231.81783,49.742924,13161880,0.99728857,-307.77805,13197665,971217}","{6475310,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:41:54.003+13","{2258,11.71521,233.34755,50.455494,3308,1,192.81352,3308,0}","{6475365,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:42:54.027+13","{10700,32.331151,234.0734,49.67855,5352,0.99999998,330.96738,5352,1}","{6475454,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:43:54.028+13","{9201,-35.671233,225.64787,50.213757,7041,0.99999963,-257.94485,7041,6}","{6475571,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:44:54.001+13","{622,-5.581195,225.44958,50.23914,2542,0.99999999,-111.56065,2542,0}","{6475613,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:45:54+13","{5558,-17.124031,234.96182,49.99421,2912,0.99999997,-324.60168,2912,0}","{6475661,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:46:54.001+13","{5376,-17.524035,225.03143,50.073128,2892,1,-306.79285,2892,0}","{6475709,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:47:54.002+13","{11878,-36.447683,234.55536,50.139534,6152,0.99999991,-325.9098,6152,2}","{6475811,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:48:54.004+13","{12273,44.544409,227.08418,49.61991,8336,0.99999963,275.52933,8336,7}","{6475949,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:49:54.004+13","{99017,-382.337769,231.0455,49.812103,78808,0.99999997,-258.98016,78808,19}","{6477262,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:50:54.003+13","{6876,-35.793021,225.32115,49.51018,9458,0.99999975,-192.12343,9458,6}","{6477419,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:55:04.005+13","{1839,-10.736201,232.37871,49.516663,3384,0.99999993,-171.304,3384,1}","{6255715,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:56:04.001+13","{6460,-19.525824,234.67532,50.337986,3250,0.99999996,-330.85782,3250,0}","{6255769,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:57:04.002+13","{1733,10.290672,225.11105,50.196163,3095,0.99999995,168.44292,3095,0}","{6255820,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:58:04.003+13","{726,-7.986303,227.31352,50.17583,4536,0.99999999,-90.96072,4536,0}","{6255895,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 18:59:01.009+13","{2242792,7069.274902,225.29591,50.329655,1126568,0.99803384,317.88425,1128788,70749}","{6255719,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:00:01.001+13","{436085,3981.492495,234.24316,50.487022,1947058,0.98801265,110.85705,1970681,304219}","{6288165,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:01:01.003+13","{7238,-22.703445,226.23795,50.466404,3644,0.99999998,-318.82275,3644,0}","{6288225,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:02:29.013+13","{521,6.279147,226.21965,49.567646,3869,0.99999991,83.048935,3869,1}","{6255722,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:04:31.004+13","{644,-5.675366,232.38275,50.125027,2700,1,-113.50293,2700,0}","{6255724,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:05:31.003+13","{1700,-18.602119,226.56076,49.786606,10446,1,-91.40088,10446,0}","{6255898,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:06:31.004+13","{3125146,9612.153446,234.87228,50.49978,1623912,0.99784711,325.826,1627415,106730}","{6282963,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:07:31.005+13","{90,2.278527,225.23892,49.50004,2925,0.99999994,39.50907,2925,1}","{6283011,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:08:31.006+13","{452,4.868709,229.47424,49.501324,2756,1,93.024574,2756,0}","{6283056,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:09:31.01+13","{166,-3.047263,230.54317,50.006607,2963,1,-54.65098,2963,0}","{6283105,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:10:31.003+13","{9958,30.987406,228.67773,49.917847,5042,0.99999991,321.3649,5042,2}","{6283189,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:11:31.002+13","{52168,307.18944,227.82329,50.49119,93885,0.99999995,169.82541,93885,28}","{6284753,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:12:31.003+13","{31507,129.757786,225.66817,49.559456,27213,0.999996,242.82167,27213,76}","{6285206,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:13:31.003+13","{909,-17.193115,227.29288,50.48687,16788,0.99999829,-52.908607,16788,31}","{6285485,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:14:31.003+13","{1908,13.189097,225.73633,49.57933,4643,0.99999992,144.72223,4643,1}","{6285562,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:15:31.005+13","{2705,29.974583,227.49573,50.020794,17188,0.99999815,90.25148,17188,33}","{6285848,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:16:31.01+13","{2687,-11.751473,232.08344,50.31402,2767,1,-228.73099,2767,0}","{6285894,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:17:31.008+13","{510,-6.357398,234.95369,50.071342,4371,0.99999998,-80.28882,4371,0}","{6285966,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:18:31.007+13","{3483,-23.90067,227.01039,50.499973,8451,1,-145.73111,8451,0}","{6286106,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:19:31.006+13","{843,-6.839213,226.60918,49.60581,2846,1,-123.399025,2846,0}","{6286153,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:20:31.005+13","{40391,-135.956793,227.95587,50.193157,23779,0.99999616,-297.0948,23779,65}","{6286549,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:21:31.005+13","{4929,20.46625,234.99962,49.61949,4692,0.99999992,240.86029,4692,1}","{6286627,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:22:31.005+13","{5999,20.377277,227.25966,50.26725,3574,1,294.39752,3574,0}","{6286686,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:23:31.016+13","{4649,15.851026,231.78638,50.46356,2903,0.99999999,293.33252,2903,0}","{6286734,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:24:31.011+13","{8789,28.515021,225.00473,50.27111,4683,0.99999985,308.2392,4683,2}","{6286812,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:25:31.004+13","{810,-8.218268,231.6404,50.47896,4472,0.99999986,-98.58602,4472,2}","{6286886,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:26:31.008+13","{5354,79.232006,229.73807,49.711266,61879,0.99997321,67.57884,61880,452}","{6287917,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:27:31.004+13","{36675,209.646021,225.668,50.479076,61028,0.99999818,174.94264,61028,116}","{6288934,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:28:31.008+13","{122095,401.761625,226.48114,49.774544,67810,0.9999971,303.90173,67810,163}","{6290064,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:29:31.009+13","{11225,-66.167194,225.64304,50.34602,19857,0.99999975,-169.65384,19857,13}","{6290394,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:30:31.006+13","{687,9.385292,225.07042,49.853195,6487,0.99999968,73.28234,6487,5}","{6290502,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:31:31.008+13","{171,14.104241,234.95592,49.580044,64172,0.99997549,12.13291,64173,449}","{6291571,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:32:31.008+13","{1206,-9.581716,228.12233,49.588257,3959,0.99999992,-125.942314,3959,1}","{6291636,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:33:31.008+13","{10443,33.245179,229.69572,50.310642,5583,1,314.12442,5583,0}","{6291729,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:34:31.007+13","{1032,-7.236715,225.24812,50.03701,2574,1,-142.61917,2574,0}","{6291771,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:35:31.005+13","{5338,16.397987,232.65039,49.655132,2726,0.99999998,325.58676,2726,0}","{6291816,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:36:31.007+13","{8511,49.540793,226.0679,49.847557,14736,1,171.80647,14736,0}","{6292061,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:37:31.001+13","{2585,15.752409,225.92094,49.646206,4899,0.99999998,164.11069,4899,0}","{6292142,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:38:31.149+13","{8766,-27.462014,227.95929,50.187477,4470,0.99999994,-319.20807,4470,1}","{6292216,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:39:31.003+13","{86712,-268.763963,234.88533,49.695656,45958,0.99999802,-322.63684,45958,91}","{6292980,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:40:31.009+13","{50339,-191.710932,233.73077,50.49859,39885,0.99999631,-262.57983,39885,108}","{6293644,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:41:31.007+13","{8543,57.371748,234.1276,49.776325,21118,0.99999948,148.91786,21118,21}","{6293995,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:42:31.006+13","{200,-3.216203,231.98654,50.461292,2769,0.99999998,-62.49296,2769,0}","{6294041,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:43:31.004+13","{528,5.45651,234.8329,49.618793,3105,0.99999995,96.90656,3105,0}","{6294092,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:44:31.005+13","{354575,-1118.13419,225.96262,50.5,179962,0.99980383,-317.17572,179997,3565}","{6297091,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:45:31.007+13","{7466,-23.339485,234.583,50.29556,4014,0.99999994,-319.92578,4014,1}","{6297157,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:46:31.003+13","{958261,3298.970973,225.30232,49.730503,575761,0.99935368,290.66086,576133,20710}","{6306752,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:47:31.006+13","{4283,14.819529,225.00069,50.291332,2595,1,289.02646,2595,0}","{6306795,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:48:31.001+13","{17447,-127.050854,230.51303,50.07233,49158,0.99998722,-137.33073,49158,248}","{6307614,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:49:31.003+13","{2262,14.946083,234.21739,49.66428,5416,0.99999985,151.3605,5416,2}","{6307704,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:50:31.002+13","{1472,-8.925396,228.37602,50.47298,2822,0.99999996,-164.93314,2822,0}","{6307751,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:51:31.002+13","{11162,-35.130679,233.16501,49.624847,6011,0.99999989,-317.73322,6011,2}","{6307851,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:52:31.006+13","{249,-4.520041,232.37384,50.310047,4421,0.99999991,-55.19954,4421,1}","{6307924,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:53:31.003+13","{27000,81.276938,234.99829,50.4793,13510,0.99999963,332.20728,13511,11}","{6308149,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:54:31.005+13","{4,-0.48773,228.24567,49.756546,2950,1,-8.61161,2950,0}","{6308198,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:55:31.007+13","{5,-0.532729,231.77063,49.53763,2850,1,-10.037893,2850,0}","{6308245,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:56:31.002+13","{1395,8.905996,225.35481,49.662037,2887,0.99999997,156.6481,2887,0}","{6308293,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:57:31.004+13","{79243,251.889177,226.48412,49.977386,41070,0.99999991,314.59732,41070,17}","{6308977,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:58:31.02+13","{10929,-33.323538,233.97714,49.928436,5562,0.99999989,-327.97684,5562,2}","{6309069,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 19:59:31.007+13","{363,6.500305,231.2024,50.20603,6207,1,55.976772,6207,0}","{6309172,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:00:31.003+13","{4320,-16.190384,225.75908,49.84807,3092,0.99999997,-266.87213,3092,0}","{6309223,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:01:31.004+13","{5852,135.208426,234.04646,50.492954,171071,0.99985584,43.288006,171096,2905}","{6312074,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:02:31.003+13","{4989,17.406901,232.05717,49.659603,3269,0.99999996,286.66705,3269,0}","{6312128,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:03:31.006+13","{65012,205.745034,234.99939,50.461178,35957,0.99999407,315.9893,35957,123}","{6312727,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:04:31.005+13","{1251,-8.515192,231.978,49.56124,3117,0.99999998,-147.00172,3117,0}","{6312778,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:05:31.006+13","{12369,-41.513795,231.88426,50.485588,7491,0.99999998,-297.95633,7491,1}","{6312902,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:06:31.006+13","{5477,17.325633,226.81902,50.007698,2819,0.99999998,316.1244,2819,0}","{6312948,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:07:31.005+13","{621,-5.64897,227.85512,50.49636,2664,0.99999997,-110.070526,2664,0}","{6312992,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:08:31.006+13","{581,-7.830114,234.89565,50.480064,5814,0.99999999,-74.30142,5814,0}","{6313088,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:09:31.003+13","{18751,-64.388525,225.22685,49.734985,11215,0.99999905,-291.22397,11215,15}","{6313274,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:10:31.004+13","{5170,-16.182256,230.15018,49.503986,2682,0.99999999,-319.49838,2682,0}","{6313318,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:11:31.005+13","{6430,-19.56516,233.55948,50.488132,3247,0.99999994,-328.65912,3247,1}","{6313372,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:12:31.004+13","{2506,-31.331876,225.24953,50.0024,19869,0.99999968,-80.0071,19869,15}","{6313703,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:13:30.912+13","{678,-6.624301,226.37646,49.856495,3314,0.99999994,-102.42026,3314,1}","{6313758,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:14:31.004+13","{3418,-15.432705,225.27396,50.141327,3535,0.99999993,-221.49179,3535,1}","{6313817,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:15:31.003+13","{4943,22.489793,233.48772,50.457787,5577,0.99999997,219.8228,5577,1}","{6313909,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:16:31.004+13","{650,7.21166,234.45964,50.01686,4396,1,90.16749,4396,0}","{6313982,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:17:31.001+13","{5092,16.034482,225.4559,50.466663,2566,1,317.6082,2566,0}","{6314024,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:18:31.001+13","{1370,-21.046293,229.61157,49.810356,17039,0.99999959,-65.117256,17039,15}","{6314307,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:19:31.004+13","{262,3.981748,225.91278,50.41378,3086,0.99999993,65.84556,3086,1}","{6314358,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:20:31.003+13","{14303,43.777772,231.04575,49.533672,7152,0.99999976,326.7279,7152,4}","{6314477,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:21:31+13","{7263,41.957693,234.98315,49.954338,13382,0.99999997,173.11621,13382,3}","{6314700,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:22:31.002+13","{7996,-29.310074,233.96698,49.52761,5880,0.9999998,-272.82605,5880,3}","{6314798,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:23:31.003+13","{6687,175.033871,229.0885,50.463474,240417,0.99997852,38.20787,240422,1575}","{6318805,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:24:31.003+13","{226693,796.450506,230.25241,49.52534,148348,0.99999565,284.6304,148349,437}","{6321277,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:25:31.002+13","{5100,15.970833,226.74442,49.97283,2571,1,319.34195,2571,0}","{6321319,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:26:31+13","{600,-5.55874,225.70073,50.449024,2619,1,-108.09974,2619,0}","{6321362,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:27:31.003+13","{35452,155.461461,228.62978,49.5625,35633,0.9999986,228.04976,35633,59}","{6321955,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:28:31.004+13","{615644,1857.742667,234.42291,49.938843,308051,0.99997933,331.40088,308057,1980}","{6327089,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:29:31+13","{5551,17.143694,233.58855,50.47081,2888,0.99999996,323.80148,2888,0}","{6327137,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:30:31.002+13","{2804,-12.766767,228.00381,49.704273,3021,1,-219.64212,3021,0}","{6327187,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:31:31.004+13","{843,6.565986,225.37193,50.445866,2596,1,128.43243,2596,0}","{6327230,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:32:31.11+13","{2692,12.9112,234.53941,49.553265,3406,1,208.51654,3406,0}","{6327286,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:33:31.004+13","{511,5.119462,227.65665,49.834877,2658,1,99.816986,2658,0}","{6327330,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:34:31.006+13","{8649,-26.589604,230.24103,50.428234,4332,0.99999989,-325.3072,4332,2}","{6327402,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:35:31.004+13","{35396,184.918123,225.21324,49.531082,48998,0.9999915,191.4188,48998,202}","{6328218,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:36:31.001+13","{7269,-23.494611,225.18207,49.89449,3850,0.99999994,-309.42523,3850,1}","{6328282,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:37:31.004+13","{5977,-33.665772,234.50142,50.498425,10427,1,-177.54625,10427,0}","{6328455,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:38:31.004+13","{490558,48587.514387,227.89496,49.502037,2253174,0.09494743,106.336555,23730754,23623545}","{6366007,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:39:31.005+13","{805,6.546358,225.50021,49.607155,2706,1,122.99941,2706,0}","{6366052,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:40:31.002+13","{1562,-9.040122,231.26727,49.812893,2797,0.99999999,-172.85863,2797,0}","{6366098,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:41:31.006+13","{2142,-14.837956,234.12701,49.948486,5634,0.99999991,-144.36168,5634,2}","{6366191,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:42:31.006+13","{3725,-17.443835,231.07904,49.504078,4361,0.99999987,-213.57439,4361,2}","{6366263,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:43:31.006+13","{192,-3.476551,225.32469,49.815975,3190,1,-55.325256,3190,0}","{6366316,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:44:31.005+13","{13816,141.094335,225.10832,50.493267,73012,0.99998431,97.92446,73013,408}","{6367532,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:45:31.006+13","{79465,-334.552678,234.76245,50.154987,77621,0.99997026,-237.53352,77624,598}","{6368825,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:46:31.006+13","{4380,-16.78038,230.26906,49.677174,3408,1,-261.0611,3408,0}","{6368881,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:47:31.003+13","{253549,793.371598,234.99142,50.487293,137086,1,319.58456,137086,6}","{6371165,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:48:31.006+13","{330,-6.172493,227.03679,49.619957,5942,0.99999982,-53.543842,5942,3}","{6371264,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:49:31.002+13","{1315,8.65254,232.15593,49.50711,3067,1,152.02448,3067,0}","{6371315,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:50:31.002+13","{7125,-28.47062,225.47559,49.501114,5783,1,-250.26956,5783,0}","{6371411,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:51:31.006+13","{7954,24.48738,234.54059,49.529675,4146,0.99999996,324.85684,4146,1}","{6371480,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:52:31.006+13","{3753,-13.701122,226.3269,49.655933,2561,0.99999995,-273.97147,2561,0}","{6371522,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:53:31.022+13","{8091,29.135142,231.93416,49.500015,5643,0.99999993,277.73767,5643,2}","{6371616,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:54:31.025+13","{6,-0.575385,226.96643,49.842213,2729,1,-10.86037,2729,0}","{6371661,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:55:31.011+13","{1918,-10.139012,229.15535,49.623276,2814,0.99999995,-189.1793,2814,0}","{6371707,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:56:31.009+13","{12110,-37.976838,229.8263,49.501602,6290,0.99999993,-318.8871,6290,2}","{6371811,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:57:31.004+13","{13176,-39.654347,234.97993,50.239002,6589,0.99999976,-332.28107,6589,4}","{6371920,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:58:31.006+13","{4281,18.418735,225.48781,49.600998,4028,0.99999995,232.47815,4028,1}","{6371987,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 20:59:31.009+13","{497,5.269797,227.14165,49.97743,2881,1,94.365654,2881,0}","{6372035,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:00:31.012+13","{19112,61.303356,230.31155,49.501015,10430,0.99999987,311.76538,10430,5}","{6372208,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:01:31.009+13","{169237,547.408935,228.42743,49.72046,92389,0.99999965,309.16174,92389,77}","{6373747,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:02:31.01+13","{596,8.462358,225.18364,49.541634,6088,0.99999983,70.47604,6088,3}","{6373848,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:03:31.007+13","{169,-3.814386,231.96051,49.517635,4626,1,-44.360928,4626,0}","{6373925,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:04:31.002+13","{84380,-265.521647,225.58105,50.49602,42515,0.99998629,-317.79733,42516,222}","{6374633,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:05:31.008+13","{298,13.089774,229.51564,49.785236,30217,0.99999993,22.81871,30217,11}","{6375136,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:06:31.009+13","{12308,-53.873206,232.9882,50.425377,12800,0.99999976,-228.46321,12800,8}","{6375349,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:07:31.004+13","{3760,-17.786394,234.3228,49.513294,4619,0.99999998,-211.42955,4619,1}","{6375425,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:08:31.002+13","{920,-23.355257,234.45528,49.531067,32572,0.99999866,-39.414196,32572,53}","{6375967,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:09:31.009+13","{71085,-223.033455,229.64862,50.438786,36904,0.99999228,-318.72156,36905,145}","{6376582,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:10:31.01+13","{453,6.786954,226.1825,49.778114,5201,0.99999985,66.75735,5201,2}","{6376668,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:11:31.007+13","{153461,-481.467517,231.58826,49.899323,81014,0.99999401,-318.73862,81014,280}","{6378018,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:12:31.004+13","{3867,29.476232,226.37392,50.352173,11511,0.99999953,131.21288,11511,11}","{6378209,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:13:31.007+13","{3596,15.443492,229.82753,50.496918,3502,0.99999999,232.90288,3502,0}","{6378267,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:14:31.02+13","{523,5.117225,225.02052,50.044914,2531,0.99999999,102.33969,2531,0}","{6378309,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:15:31.006+13","{8972,-27.578326,234.20125,50.486904,4649,1,-325.33093,4649,0}","{6378386,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:16:31.006+13","{13625,-42.454669,229.6154,49.603737,6974,0.99999966,-320.9495,6974,5}","{6378502,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:17:31.006+13","{2630,-27.38811,225.02957,49.539375,14438,0.99999984,-96.05301,14438,8}","{6378742,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:18:31.006+13","{240,3.495879,232.76195,50.140564,2758,1,68.66637,2758,0}","{6378787,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:19:31.006+13","{3101,-15.107276,234.65222,49.56245,4051,0.9999999,-205.3088,4051,1}","{6378854,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:20:31.005+13","{1330,-8.361082,234.138,49.52303,2880,0.99999996,-159.14008,2880,0}","{6378901,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:21:31.005+13","{242,-7.242737,234.9562,50.489403,11936,0.99999985,-33.49678,11936,6}","{6379099,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:22:31.003+13","{1344,8.701251,225.00002,50.385063,2851,0.99999997,154.46985,2851,0}","{6379146,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:23:31.007+13","{9457,32.436097,234.9544,49.898735,6141,0.99999997,291.57037,6141,1}","{6379248,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:24:31.005+13","{3077,-19.552664,225.00003,49.521366,6289,0.99999982,-157.38159,6289,3}","{6379352,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:25:31.006+13","{268374,-1054.079235,234.81276,50.31356,228268,0.99999751,-254.60667,228268,509}","{6383156,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:26:31.006+13","{37214,-177.37126,231.54659,49.669006,45323,0.99998743,-209.8113,45324,227}","{6383911,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:27:31.003+13","{1062,7.310071,231.69579,50.4126,2700,0.99999997,145.31308,2700,0}","{6383955,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:28:31.005+13","{1077,10.255444,234.95695,50.469147,5390,0.99999984,105.032616,5390,3}","{6384044,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:29:31.007+13","{346,4.262523,225.0051,49.503143,2652,1,81.36926,2652,0}","{6384088,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:30:31.003+13","{1645410,5637.282265,230.69554,50.498444,1026949,0.99954579,292.01266,1027416,30962}","{6401202,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:31:31.006+13","{9615,31.890731,227.60713,50.48577,5479,0.99999999,301.5207,5479,0}","{6401293,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:32:31.005+13","{6473,22.600191,225.81842,50.335007,4023,0.99999988,286.4179,4023,2}","{6401360,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:33:31.006+13","{4798,17.870099,225.49713,50.29408,3383,0.99999996,268.5231,3383,0}","{6401416,NULL,61.765}",
"7714f762-2361-4ec2-98ab-7e96807b32a6","2021-11-23 21:34:31.006+13","{7222,-24.502656,229.46155,50.32881,4376,1,-294.77994,4376,0}","{6401488,NULL,61.765}",
\.

COMMIT;
